IF NOT EXISTS(SELECT * 
              FROM   INFORMATION_SCHEMA.TABLES 
              WHERE  TABLE_NAME = 'INTEGRA_BENNER_EVENTOS') 

BEGIN
	CREATE TABLE [dbo].[INTEGRA_BENNER_EVENTOS](
		[ID] 				[uniqueidentifier] NOT NULL,
		[TABELA] 			[nvarchar](128) NOT NULL,
		[CD_EMP] 			[int] NULL,
		[CD_FILIAL] 		[int] NULL,
		[CD_REGISTRO] 	    [int] NOT NULL,
		[TP_EVENTO] 		[int] NOT NULL,
		[HR_EVENTO] 		[datetime] NOT NULL,
		[ST_EVENTO] 		[int] NOT NULL,
		[DT_ULT_ALT] 		[datetime] NULL,
		[CD_USU] 			[int] NULL,
		[DT_DOCUMENTO]  	[datetime] NOT NULL,
		[APP_NAME] 			[varchar](100) NULL,
		[IP_CLIENTE] 		[varchar](100) NULL,
		[HOST_NAME] 		[varchar](100) NULL,
		[TOPICO] 			[int] NULL,
	CONSTRAINT [PK_INTEGRA_BENNER_EVENTOS] PRIMARY KEY CLUSTERED 
	(
		[ID] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[INTEGRA_BENNER_EVENTOS] ADD  DEFAULT (newid()) FOR [ID]

	ALTER TABLE [dbo].[INTEGRA_BENNER_EVENTOS] ADD  DEFAULT (getdate()) FOR [HR_EVENTO]

	ALTER TABLE [dbo].[INTEGRA_BENNER_EVENTOS] ADD  DEFAULT ((0)) FOR [ST_EVENTO]

	ALTER TABLE [dbo].[INTEGRA_BENNER_EVENTOS] ADD  CONSTRAINT [DF_INTEGRA_BENNER_EVENTOS_DT_DOCUMENTO]  DEFAULT (getdate()) FOR [DT_DOCUMENTO]

	ALTER TABLE [dbo].[INTEGRA_BENNER_EVENTOS] ADD  DEFAULT (app_name()) FOR [APP_NAME]

	ALTER TABLE [dbo].[INTEGRA_BENNER_EVENTOS] ADD  DEFAULT (CONVERT([varchar],connectionproperty('client_net_address'))) FOR [IP_CLIENTE]

	ALTER TABLE [dbo].[INTEGRA_BENNER_EVENTOS] ADD  DEFAULT (host_name()) FOR [HOST_NAME]
	
	ALTER TABLE [dbo].[INTEGRA_BENNER_EVENTOS] WITH CHECK ADD CONSTRAINT [FK_INTEGRA_BENNER_EVENTOS_INTEGRA_BENNER_TOPICO_ID] FOREIGN KEY ([TOPICO]) REFERENCES [dbo].[INTEGRA_BENNER_TOPICO] ([ID]) 
	
	ALTER TABLE [dbo].[INTEGRA_BENNER_EVENTOS] CHECK CONSTRAINT [FK_INTEGRA_BENNER_EVENTOS_INTEGRA_BENNER_TOPICO_ID]
	  
END